/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.api;

import java.util.function.Consumer;
import java.util.function.IntPredicate;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.runelite.api.Animation;
import net.runelite.api.Client;
import net.runelite.api.Model;

public class AnimationController {
    private final Client client;
    @Nullable
    private Animation animation;
    @NonNull
    private Consumer<AnimationController> onFinished = AnimationController::loop;
    private int frame;
    private int elapsedTicks;

    public AnimationController(Client client2, int animationID) {
        this(client2, client2.loadAnimation(animationID));
    }

    public AnimationController(Client client2, Animation animation) {
        this.client = client2;
        this.setAnimation(animation);
    }

    public void setAnimation(@Nullable Animation animation) {
        this.animation = animation;
        this.reset();
    }

    public void reset() {
        this.frame = 0;
        this.elapsedTicks = 0;
    }

    public void loop() {
        if (this.animation == null) {
            return;
        }
        this.frame -= this.animation.getFrameStep();
        if (this.frame < 0 || this.frame >= this.animation.getDuration()) {
            this.frame = 0;
        }
    }

    public void tick(int ticks) {
        if (this.animation == null) {
            return;
        }
        if (this.animation.isMayaAnim()) {
            this.frame += ticks;
            if (this.frame >= this.animation.getDuration()) {
                this.onFinished.accept(this);
                if (this.frame < 0 || this.animation == null || this.frame >= this.animation.getDuration()) {
                    this.animation = null;
                }
            }
        } else {
            this.elapsedTicks += ticks;
            int[] frameLengths = this.animation.getFrameLengths();
            while (this.elapsedTicks > frameLengths[this.frame]) {
                this.elapsedTicks -= frameLengths[this.frame];
                ++this.frame;
                if (this.frame < frameLengths.length) continue;
                this.onFinished.accept(this);
                if (this.frame >= 0 && this.animation != null && this.frame < frameLengths.length) continue;
                this.animation = null;
                return;
            }
        }
    }

    public Model animate(Model model) {
        return this.animate(model, null);
    }

    public Model animate(Model model, @Nullable AnimationController other) {
        if (other != null) {
            return this.client.applyTransformations(model, this.animation, this.getPackedFrame(), other.animation, other.getPackedFrame());
        }
        return this.client.applyTransformations(model, this.animation, this.getPackedFrame(), null, 0);
    }

    private int getPackedFrame() {
        if (this.animation == null) {
            return 0;
        }
        IntPredicate interpFilter = this.client.getAnimationInterpolationFilter();
        if (interpFilter == null || !interpFilter.test(this.animation.getId())) {
            return this.frame;
        }
        return Integer.MIN_VALUE | this.elapsedTicks << 16 | this.frame;
    }

    @Nullable
    public Animation getAnimation() {
        return this.animation;
    }

    public AnimationController setOnFinished(@NonNull Consumer<AnimationController> onFinished) {
        if (onFinished == null) {
            throw new NullPointerException("onFinished is marked non-null but is null");
        }
        this.onFinished = onFinished;
        return this;
    }

    public int getFrame() {
        return this.frame;
    }

    public AnimationController setFrame(int frame) {
        this.frame = frame;
        return this;
    }
}

